
--------------------------- General Geppetto UI -----------------------------------

struct NumFramesSpinnerCallback
(
	fn OnChanged iValue = 
	(
		pop.numFrames = iValue
		updatetoolbarbuttons() -- for typed in values
	),
	fn onButtonUp iValue =
	(
		updatetoolbarbuttons()
	),
	fn getValue =
	(
		pop.numFrames
	)
)

struct SeatFemalePctSpinnerCallback
(
	fn OnChanged fValue = 
	(
		pop.seatFemalePct = fValue
		updatetoolbarbuttons() -- for typed in values
	),
	fn onButtonUp fValue =
	(
		updatetoolbarbuttons()
	),
	fn getValue =
	(
		pop.seatFemalePct
	)
)

fn popSkinCharSelected =
(
	for i in selection do
		if classof i == popSkinObject
		then return true
	return false
)

--------------------------- Crowd Area Draw Tools -----------------------------------

fn CrowdAreaToolToggle toolType =
(
	currentTool = CrowdAreaGetActiveTool()
	if (currentTool != 0) then --End any active tool
	(
		max modify mode
		CrowdAreaEnd()
		PBEndTrack()
		if (currentTool != toolType) do --Start another tool
		(
			CrowdAreaSetup toolType
			PBStartTrack CrowdAreaDrawing 1
--			CrowdAreaEnd()
		)
	)
	else --Start tool
	(
		CrowdAreaSetup toolType
		PBStartTrack CrowdAreaDrawing 1
--		CrowdAreaEnd()
	)
)

fn CrowdAreaEndTools =
(
	CrowdAreaEnd()
	PBEndTrack()
)

struct CrowdAreaBrushSizeSpinnerCallback
(
	fn OnChanged iValue = 
	(
		CrowdAreaSetBrushSize iValue
	),
	fn getValue =
	(
		CrowdAreaGetBrushSize()
	)
)

struct CrowdAreaBrushSizePathSpinnerCallback
(
	fn OnChanged iValue = 
	(
		CrowdAreaSetBrushSizePath iValue
	),
	fn getValue =
	(
		CrowdAreaGetBrushSizePath()
	)
)

struct CrowdAreaCircleSidesSpinnerCallback
(
	fn OnChanged iValue = 
	(
		CrowdAreaSetCircleSides iValue
	),
	fn getValue =
	(
		CrowdAreaGetCircleSides()
	)
)


--------------------------- Called by Orchestrator Actions -----------------------------------

fn ActionCreateFlow =
(
	if (CrowdAreaGetActiveTool() == 0) then
	(
		subobjectlevel = 0
		CrowdAreaSetup 6
		PBStartTrack CrowdPathDrawing 1
--		CrowdAreaEnd()
	)
	else
	(
		currentTool = CrowdAreaGetActiveTool()
		CrowdAreaEnd()
		PBEndTrack()
		if (currentTool != 6) do
		(
			subobjectlevel = 0
			CrowdAreaSetup 6
			PBStartTrack CrowdPathDrawing 1
--			CrowdAreaEnd()
		)
	)
)

fn ActionEditFlow =
(
	if (CrowdAreaGetActiveTool() != 0) do
	(
		CrowdAreaEnd()
		PBEndTrack()
	)
	if (subobjectlevel == 1 or subobjectlevel == 2) then
	(
		subobjectlevel = 0
	)
	else
	(
		max modify mode
		subobjectlevel = 1
	)
)

fn ActionExtendFlow =
(
	currentTool = CrowdAreaGetActiveTool()
	CrowdAreaEnd()
	PBEndTrack()
	if (currentTool != 7) do
	(
		CrowdAreaSetup 7
		PBStartTrack CrowdPathExtend
		--CrowdAreaEnd()
		--CrowdDoRestartPathTool() --If user clicked endpoint, start path drawing tool
	)
)

fn ActionIdleAddMode =
(
	if (CrowdAreaGetAddMode() == 1) then
	(
		CrowdAreaSetAddMode 0
	)
	else
	(
		CrowdAreaSetAddMode 1
	)
	updateToolbarButtons()
)

fn ActionIdleSubtractMode =
(
	if (CrowdAreaGetAddMode() == 2) then
	(
		CrowdAreaSetAddMode 0
	)
	else
	(
		CrowdAreaSetAddMode 2
	)
	updateToolbarButtons()
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBakgWvqiU0iaN7Qun9myY3JUwUT66hqTmM
-- xILbjhM7cJ7M7pvFCkvOS5+DQdypPUi0XM/LbqVPxQso+zWXmvBDA28uYNYnDGg8
-- JnAgS3fSWHoD78JYA6kneDn8aKrVYVnW7gu154gZBEWna+Z14r8HMxS3BDhVrPEM
-- yPq6WaeNtaRv455LnRFlBUxC9SCRBmTApKgPYx+cwfcfC87ozC0wtdByAthU2BUU
-- 6+E5CiHWfmDjCY/IXN1NEOP/OL430r9ctRYo3hYxgE3Sgd5pIQH27nY4FHwwGmHc
-- ngfeKy7efVnkruAbyc7H5w45oLACfoBx0v55sfEqTmIRI74s21Te
-- -----END-SIGNATURE-----